<?php
/*
Plugin Name: Superfly Button
Plugin URI:  
Description: Create advanced buttons, have multiple buttons in one row and more
Version:     1.0.0
Author:      BeSuperfly
Author URI:  https://besuperfly.com
License:     GPL2
License URI: https://www.gnu.org/licenses/gpl-2.0.html
Text Domain: bsf-button
Domain Path: /languages

Superfly Button is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
any later version.

Superfly Button is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Superfly Button. If not, see https://www.gnu.org/licenses/gpl-2.0.html.
*/

global $iiVersion;
$iiVersion = '1.0.0';

// API Licensing
if ( ! class_exists( 'WC_AM_Client_2_7' ) ) {
    require_once( plugin_dir_path( __FILE__ ) . 'wc-am-client.php' );
}


if ( class_exists( 'WC_AM_Client_2_7' ) ) {
    /**
     * This file is only an example that includes a plugin header, and this code used to instantiate the client object. The variable $wcam_lib
     * can be used to access the public properties from the WC_AM_Client class, but $wcam_lib must have a unique name. To find data saved by
     * the WC_AM_Client in the options table, search for wc_am_client_{product_id}, so in this example it would be wc_am_client_13.
     *
     * All data here is sent to the WooCommerce API Manager API, except for the $software_title, which is used as a title, and menu label, for
     * the API Key activation form the client will see.
     *
     * ****
     * NOTE
     * ****
     * If $product_id is empty, the customer can manually enter the product_id into a form field on the activation screen.
     *
     * @param string $file             Must be __FILE__ from the root plugin file, or theme functions, file locations.
     * @param int    $product_id       Must match the Product ID number (integer) in the product.
     * @param string $software_version This product's current software version.
     * @param string $plugin_or_theme  'plugin' or 'theme'
     * @param string $api_url          The URL to the site that is running the API Manager. Example: https://www.toddlahman.com/
     * @param string $software_title   The name, or title, of the product. The title is not sent to the API Manager APIs, but is used for menu titles.
     *
     */

    global $iiVersion;
    global $ii_wc_api;
    $ii_wc_api = new WC_AM_Client_2_7( __FILE__, '631753', $iiVersion, 'plugin', 'https://besuperfly.com/', 'Superfly Button' );
}



if ( ! function_exists( 'bsf_initialize_extension' ) ):
/**
 * Creates the extension's main class instance.
 *
 * @since 1.0.0
 */
function bsf_initialize_extension() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/SuperflyButton.php';
}
add_action( 'divi_extensions_init', 'bsf_initialize_extension' );
endif;
