<?php

class BSF_SuperflyButtonWrapper extends ET_Builder_Module
{

	public $slug             = 'bsf_button_wrapper';
	public $vb_support       = 'on';
	public $child_slug       = 'bsf_button_child';
	public $child_item_text  = 'Superfly Button';

	protected $module_credits = array(
		'module_uri' => '',
		'author'     => 'BeSuperfly',
		'author_uri' => 'https://besuperfly.com',
	);

	public function init()
	{
		$this->name = esc_html__('Superfly Button', 'bsf-button');
		$this->main_css_element = '%%order_class%%';
	}

	public function get_fields()
	{
		return array(
			'desktop_columns' => array(
				'label' => esc_html__('Columns', 'bsf-button'),
				'type'  => 'select',
				'option_category' => 'configuration',
				'default' => '1',
				'options' => array(
					'1'  => esc_html__('1', 'bsf-button'),
					'2'  => esc_html__('2', 'bsf-button'),
					'3'  => esc_html__('3', 'bsf-button'),
					'4'  => esc_html__('4', 'bsf-button'),
					'5'  => esc_html__('5', 'bsf-button'),
					'6'  => esc_html__('6', 'bsf-button'),
					'7'  => esc_html__('7', 'bsf-button'),
					'8'  => esc_html__('8', 'bsf-button'),
					'9'  => esc_html__('9', 'bsf-button'),
					'10' => esc_html__('10', 'bsf-button')
				),
				'description' => 'Choose where to place tab navigation.',
				'tab_slug'        => 'general',
				'toggle_slug'     => 'layout_general',
				'sub_toggle'      => 'desktop',
			),
			'tablet_columns' => array(
				'label' => esc_html__('Columns', 'bsf-button'),
				'type'  => 'select',
				'option_category' => 'configuration',
				'default' => '1',
				'options' => array(
					'1'  => esc_html__('1', 'bsf-button'),
					'2'  => esc_html__('2', 'bsf-button'),
					'3'  => esc_html__('3', 'bsf-button'),
					'4'  => esc_html__('4', 'bsf-button'),
					'5'  => esc_html__('5', 'bsf-button'),
					'6'  => esc_html__('6', 'bsf-button'),
					'7'  => esc_html__('7', 'bsf-button'),
					'8'  => esc_html__('8', 'bsf-button'),
					'9'  => esc_html__('9', 'bsf-button'),
					'10' => esc_html__('10', 'bsf-button')
				),
				'description' => 'Choose where to place tab navigation.',
				'tab_slug'        => 'general',
				'toggle_slug'     => 'layout_general',
				'sub_toggle'      => 'tablet',
			),
			'mobile_columns' => array(
				'label' => esc_html__('Columns', 'bsf-button'),
				'type'  => 'select',
				'option_category' => 'configuration',
				'default' => '1',
				'options' => array(
					'1'  => esc_html__('1', 'bsf-button'),
					'2'  => esc_html__('2', 'bsf-button'),
					'3'  => esc_html__('3', 'bsf-button'),
					'4'  => esc_html__('4', 'bsf-button'),
					'5'  => esc_html__('5', 'bsf-button'),
					'6'  => esc_html__('6', 'bsf-button'),
					'7'  => esc_html__('7', 'bsf-button'),
					'8'  => esc_html__('8', 'bsf-button'),
					'9'  => esc_html__('9', 'bsf-button'),
					'10' => esc_html__('10', 'bsf-button')
				),
				'description' => 'Choose where to place tab navigation.',
				'tab_slug'        => 'general',
				'toggle_slug'     => 'layout_general',
				'sub_toggle'      => 'mobile',
			),
			'column_gap' => array(
				'label'           => esc_html__('Column Gap', 'et_builder'),
				'type'            => 'range',
				'description'     => esc_html__('Set gap size for tiled nav items.', 'et_builder'),
				'range_settings' => array(
					'min' => '0',
					'max' => '50',
					'step' => '1'
				),
				'validate_unit' => true,
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'margin_padding',
				'mobile_options'  => true,
				'sticky'          => true,
			),
			'row_gap' => array(
				'label'           => esc_html__('Row Gap', 'et_builder'),
				'type'            => 'range',
				'description'     => esc_html__('Set gap size for tiled nav items.', 'et_builder'),
				'range_settings' => array(
					'min' => '0',
					'max' => '50',
					'step' => '1'
				),
				'validate_unit' => true,
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'margin_padding',
				'mobile_options'  => true,
				'sticky'          => true,
			)
		);
	}

	public function get_advanced_fields_config()
	{
		return array(
			'text'         => false,
			'link_options' => false,
			'fonts'        => array(
				'body' => false
			)
		);
	}

	public function get_settings_modal_toggles()
	{
		return array(
			'general' => array(
				'toggles' => array(
					'layout_general' => array(
						'title' => esc_html__('Layout', 'divi_flash'),
						'tabbed_subtoggles' => true,
						'sub_toggles' => array(
							'desktop' => array(
								'name' => 'Desktop',
								'icon' => 'desktop',
							),
							'tablet' => array(
								'name' => 'Tablet',
								'icon' => 'tablet',
							),
							'mobile' => array(
								'name' => 'Mobile',
								'icon' => 'phone',
							),
						),
					),
				)
			),
			'advanced' => array(
				'toggles' => array()
			)
		);
	}

	public function render($attrs, $content = null, $render_slug)
	{

		$desktop_columns = $this->props['desktop_columns'];
		$tablet_columns  = $this->props['tablet_columns'];
		$mobile_columns  = $this->props['mobile_columns'];
		$column_gap      = $this->props['column_gap'];
		$row_gap         = $this->props['row_gap'];

		$desktop_columns_class = 'bsc_desktop_columns_' . $desktop_columns;
		$tablet_columns_class  = 'bsc_tablet_columns_' . $tablet_columns;
		$mobile_columns_class  = 'bsc_mobile_columns_' . $mobile_columns;

		$this->add_classname($desktop_columns_class);
		$this->add_classname($tablet_columns_class);
		$this->add_classname($mobile_columns_class);

		ET_Builder_Element::set_style($render_slug, array(
			'selector' => "%%order_class%% > .et_pb_module_inner",
			'declaration' => "row-gap: {$row_gap}px; column-gap: {$column_gap}px;"
		));

		return sprintf('%1$s', $this->content);
	}
}

new BSF_SuperflyButtonWrapper;
