<?php

class BSF_SuperflyButtonItem extends ET_Builder_Module {

    public $slug = 'bsf_button_child';
    public $vb_support = 'on';
    public $type = 'child';
    public $child_title_var = 'bsf_title';
    public $advanced_setting_title_text = 'New Superfly Button';

    protected $module_credits = [
        'module_uri' => 'https://besuperfly.com',
        'author' => 'BeSuperfly',
        'author_uri' => 'https://besuperfly.com',
    ];

    public function init() {
        $this->name = esc_html__('Superfly Button', 'bsf-button');
        $this->main_css_element = '%%order_class%%';
    }

    public function get_fields() {
        return [
            'bsf_title' => [
                'label' => esc_html__('Title', 'bsf-button'),
                'type' => 'text',
                'option_category' => 'basic_option',
                'description' => esc_html__('Set a title for your tab.', 'bsf-button'),
                'toggle_slug' => 'main_content',
                'default'     => 'Title'
            ],
            'sub_title' => [
                'label' => esc_html__('Sub Title', 'bsf-button'),
                'type' => 'text',
                'option_category' => 'basic_option',
                'description' => esc_html__('Set a title for your tab.', 'bsf-button'),
                'toggle_slug' => 'main_content',
            ],
            'onclick' => [
                'label' => esc_html__('Onclick Attribute', 'bsf-button'),
                'type' => 'text',
                'option_category' => 'basic_option',
                'description' => esc_html__('Enter a function name to trigger your custom JavaScript. Can be used for Google Events as well.', 'bsf-button'),
                'toggle_slug' => 'link_options',
            ],
            'sub_title_spacing' => [
                'label' => esc_html__('Sub Title Spacing', 'bsf-button'),
                'type' => 'range',
                'tab_slug' => 'advanced',
                'toggle_slug' => 'sub_title',
                'default' => '10px',
                'range_settings' => [
                    'min' => '1',
                    'max' => '50',
                    'step' => '1',
                ],
                'allowed_units' => ['%', 'px', 'rem'],
                'mobile_options' => true,
                'validate_unit' => true,
                'description' => esc_html__('Adjust the spacing above the subtitle.', 'bsf-button'),
            ],
            'animate_gradient'  => array(
                'label'           => esc_html__( 'Animate Gradient Background?', 'bsf-button' ),
				'type'            => 'yes_no_button',
                'options'         => array(
					'off' => esc_html__( 'No', 'divi_flash' ),
					'on'  => esc_html__( 'Yes', 'divi_flash' ),
                ),
                'default'         => 'off',
				'toggle_slug'     => 'background'
            ),
            'button_icon' => array(
				'label'                 => esc_html__( 'Use Icon', 'bsf-button' ),
				'type'                  => 'yes_no_button',
				'options'               => array(
					'off' => esc_html__( 'No', 'bsf-button' ),
					'on'  => esc_html__( 'Yes', 'bsf-button' ),
                ),
                'affects'               => array(
                    'font_icon',
                    'icon_color',
                    'icon_placement',
                    'icon_font_size',
                    'icon_spacing',
                    'icon_hover'
				),
				'description'           => esc_html__( 'Here you can choose whether icon set below should be used.', 'bsf-button' ),
                'default'               => 'on',
                'default_on_front'      => 'on',
                'toggle_slug'           => 'button',
                'tab_slug'              => 'advanced'  
            ),
            'font_icon' => array(
				'label'               => esc_html__( 'Icon', 'bsf-button' ),
				'type'                => 'select_icon',
				'class'               => array( 'et-pb-font-icon' ),
				'toggle_slug'         => 'button',
                'tab_slug'            => 'advanced' ,
				'description'         => esc_html__( 'Choose an icon to display with your blurb.', 'bsf-button' ),
				'depends_show_if'     => 'on',
            ),
            'icon_color' => array(
				'default'           => "#2ea3f2",
				'default_on_front'	=> true,
				'label'             => esc_html__( 'Icon Color', 'bsf-button' ),
				'type'              => 'color-alpha',
				'description'       => esc_html__( 'Here you can define a custom color for your icon.', 'bsf-button' ),
				'depends_show_if'   => 'on',
				'toggle_slug'       => 'button_style',
                'tab_slug'          => 'advanced' ,
                'hover'             => 'tabs'
            ),
            'icon_font_size' => array(
				'label'           => esc_html__( 'Icon Font Size', 'bsf-button' ),
				'type'            => 'range',
				'option_category' => 'font_option',
                'toggle_slug'       => 'button',
                'tab_slug'          => 'advanced' ,
                'default'         => '12px',
				'default_unit'    => 'px',
				'range_settings' => array(
					'min'  => '1',
					'max'  => '120',
					'step' => '1',
				),
				'mobile_options'  => true,
				'responsive'      => true,
                'depends_show_if'   => 'on'
            ),
            'icon_placement'   => array(
                'label'             => esc_html__('Icon Placement', 'bsf-button'),
                'type'              => 'select',
                'options'           => array(
                    'left'          => esc_html__('Left', 'bsf-button'),
                    'right'         => esc_html__('Right', 'bsf-button')
                ),
                'default'           => 'right',
                'toggle_slug'       => 'button',
                'tab_slug'          => 'advanced',
                'depends_show_if'   => 'on'
            ),
            'icon_spacing' => array(
				'label'           => esc_html__( 'Space Between Icon and Text', 'bsf-button' ),
				'type'            => 'range',
                'toggle_slug'       => 'button',
                'tab_slug'          => 'advanced' ,
                'default'         => '10px',
				'default_unit'    => 'px',
                'allowed_units' => ['%', 'px', 'rem'],
				'range_settings' => array(
					'min'  => '1',
					'max'  => '120',
					'step' => '1',
				),
				'mobile_options'  => true,
				'responsive'      => true,
                'depends_show_if'   => 'on'
            ),
            'icon_hover' => array(
				'label' => esc_html__('Show Icon', 'bsf-button'),
				'type'  => 'select',
				'option_category' => 'configuration',
				'default' => 'always',
				'options' => array(
					'always'  => esc_html__('Always', 'bsf-button'),
					'hover_only'  => esc_html__('Hover Only', 'bsf-button'),
				),
				'description' => 'Choose where to place tab navigation.',
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'button',
                'depends_show_if'   => 'on'
			),
        ];
    }

    public function get_settings_modal_toggles() {
        return [
            'general' => [
                'toggles' => [
                    'menu' => [
                        'title' => esc_html__('Menu', 'et_builder'),
                    ],
                ],
            ],
            'advanced' => [
                'toggles' => [
                    'button' => [
                        'title' => esc_html__('Button', 'et_builder'),
                        'priority' => 1,
                    ],
                    'sub_title' => [
                        'title' => esc_html__('Sub Title', 'et_builder'),
                        'priority' => 2,
                    ],
                ],
            ],
        ];
    }

    public function get_advanced_fields_config() {
        return [
            'animations' => [
                'css' => [
                    'main' => "{$this->main_css_element}", 
                ],
                'options' => [
                    'duration' => [
                        'default' => '500ms',
                    ],
                    'delay' => [
                        'default' => '0ms',
                    ],
                    'intensity' => [
                        'default' => '50%',
                    ],
                ],
            ],
            'animation_settings' => [
                'css' => [
                    'main' => "{$this->main_css_element}", 
                ],
                'options' => [
                    'duration' => [
                        'default' => '500ms',
                    ],
                    'delay' => [
                        'default' => '0ms',
                    ],
                    'intensity' => [
                        'default' => '50%',
                    ],
                ],
            ],
            'animation' => [
                'css' => [
                    'main' => "{$this->main_css_element}", 
                ],
                'options' => [
                    'duration' => [
                        'default' => '500ms',
                    ],
                    'delay' => [
                        'default' => '0ms',
                    ],
                    'intensity' => [
                        'default' => '50%',
                    ],
                ],
            ],
            'background' => [
                'css' => [
                    'main' => "{$this->main_css_element} a.bsf_button",
                    'important' => true,
                ],
            ],
            'borders'         => array(
				'default' => array(
					'css'      => array(
						'main' => array(
							'border_radii'  => "{$this->main_css_element} a.bsf_button",
							'border_styles' => "{$this->main_css_element} a.bsf_button",
						),
					),
					'defaults' => array(
						'border_radii'  => 'on|3px|3px|3px|3px',
						'border_styles' => array(
							'width' => '1px',
							'color' => '#d9d9d9',
							'style' => 'solid',
						),
					),
				),
			),
            'box_shadow' => array(
                'default' => array(
                    'css' => array(
                        'main' => "{$this->main_css_element} a.bsf_button",
                    )
                )
            ),
            'max_width' => array(
				'css' => array(
					'max_width' => "{$this->main_css_element} a.bsf_button",
					'width' => "{$this->main_css_element} a.bsf_button",
				),
			),
            'margin_padding' => array(
                'css' => array(
                    'main' => "{$this->main_css_element} a.bsf_button",
					'important' => 'all',
				),
                'use_margin' => false,
                'use_padding' => true
            ),
            'text' => false,
            'fonts' => [
                'sub_title' => [
                    'label' => esc_html__('Sub Title', 'et_builder'),
                    'css' => [
                        'main' => "{$this->main_css_element} a.bsf_button .bsf-button_sub-title",
                        'hover' => "{$this->main_css_element} a.bsf_button:hover .bsf-button_sub-title",
                        'toggle_priority' => 1,
                    ],
                    'defaults' => array(
                        'font_size' => '14px',
                    ),
                    'use_sticky' => true,
                    'hide_text_align' => true,
                    'toggle_slug' => 'sub_title',
                ],
                'button' => [
                    'label' => esc_html__('Button', 'et_builder'),
                    'css' => [
                        'main' => "{$this->main_css_element} a.bsf_button",
                        'toggle_priority' => 1,
                    ],
                    'use_sticky' => true,
                    'hide_text_align' => true,
                    'toggle_slug' => 'button',
                ],
            ],
        ];
    }

    public function render($attrs, $content = null, $render_slug ) {

        $this->remove_classname(['et_pb_module']);


        $bsf_title = $this->props['bsf_title'];
        $bsf_sub_title = !empty($this->props['sub_title']) ? "<span class='bsf-button_sub-title'>{$this->props['sub_title']}</span>" : '';
        $bsf_link = $this->props['link_option_url'] ?? '';
        $bsf_target = $this->props['link_option_url_target'] ?? '_blank';
        $bsf_sub_title_spacing = $this->props['sub_title_spacing'] ?? '10px';
        $bsf_icon_spacing = $this->props['icon_spacing'] ?? '10px';
        $bsf_icon_placement = $this->props['icon_placement'];
        $bsf_button_font_icon = $this->props['font_icon'] ?? '5';
        $bsf_button_icon_size = isset( $this->props['icon_font_size'] ) && $this->props['icon_font_size'] && '12px' !== $this->props['icon_font_size'] ? $this->props['icon_font_size'] : '12px';
        $bsf_button_icon = 'off' !== $this->props['button_icon'] ? sprintf('<span class="et-pb-icon bsf_button_icon">%1$s</span>',
        '' !== $bsf_button_font_icon ? esc_attr( et_pb_process_font_icon( $bsf_button_font_icon ) ) : '5'
        ) : '';
        $icon_hover = $this->props['icon_hover'];

        if('on' === $this->props['button_icon']){
            $this->add_classname('bsf_button_has_icon');

            if(method_exists('ET_Builder_Module_Helper_Style_Processor', 'process_extended_icon')) {
                $this->generate_styles(
                    array(
                        'utility_arg'    => 'icon_font_family',
                        'render_slug'    => $render_slug,
                        'base_attr_name' => 'font_icon',
                        'important'      => true,
                        'selector'       => '%%order_class%% .bsf_button_icon',
                        'processor'      => array(
                            'ET_Builder_Module_Helper_Style_Processor',
                            'process_extended_icon',
                        ),
                    )
                );
            }

            if('hover_only' === $icon_hover){
                $this->add_classname('bsf_button_icon_hover');
            }
        }

        if('on' === $this->props['use_background_color_gradient'] && 'on' === $this->props['animate_gradient']){
            $this->add_classname('et_pb_has_background_gradient');
        }

        

        if('left' === $bsf_icon_placement){
            $this->add_classname('bsf_button_icon_left');
        }

        ET_Builder_Element::set_style($render_slug, [
            'selector' => "%%order_class%% .bsf-button_sub-title",
            'declaration' => "margin-top: {$bsf_sub_title_spacing};",
        ]);

        ET_Builder_Element::set_style($render_slug, [
            'selector' => "%%order_class%% .bsf_button",
            'declaration' => "column-gap: {$bsf_icon_spacing};"
        ]);

        ET_Builder_Element::set_style($render_slug, [
            'selector' => "%%order_class%% .bsf_button_icon",
            'declaration' => "font-size: {$bsf_button_icon_size};"
        ]);
 
        return sprintf(
            '<a class="bsf_button" href="%3$s" target="%4$s"><span class="bsf-button_title">%1$s%2$s</span>%5$s</a>',
            $bsf_title,
            $bsf_sub_title,
            $bsf_link,
            $bsf_target,
            $bsf_button_icon
        );
    }
}

new BSF_SuperflyButtonItem();
