<?php
/*
* Plugin Name: Divi Under Construction
* Plugin URI: https://besuperfly.com/product/divi-under-construction/
* Description: Use any page as an Under Construction page for anonymous users, or optionally allow access by IP address.
* Version: 1.3.1
* Author: BeSuperfly
* Author URI: https://besuperfly.com/
* License: GPL3
*/

global $ducVersion;
$ducVersion = '1.3.1';

// API Licensing
if ( ! class_exists( 'WC_AM_Client_2_7' ) ) {
    require_once( plugin_dir_path( __FILE__ ) . 'wc-am-client.php' );
}
if ( class_exists( 'WC_AM_Client_2_7' ) ) {
    /**
     * This file is only an example that includes a plugin header, and this code used to instantiate the client object. The variable $wcam_lib
     * can be used to access the public properties from the WC_AM_Client class, but $wcam_lib must have a unique name. To find data saved by
     * the WC_AM_Client in the options table, search for wc_am_client_{product_id}, so in this example it would be wc_am_client_13.
     *
     * All data here is sent to the WooCommerce API Manager API, except for the $software_title, which is used as a title, and menu label, for
     * the API Key activation form the client will see.
     *
     * ****
     * NOTE
     * ****
     * If $product_id is empty, the customer can manually enter the product_id into a form field on the activation screen.
     *
     * @param string $file             Must be __FILE__ from the root plugin file, or theme functions, file locations.
     * @param int    $product_id       Must match the Product ID number (integer) in the product.
     * @param string $software_version This product's current software version.
     * @param string $plugin_or_theme  'plugin' or 'theme'
     * @param string $api_url          The URL to the site that is running the API Manager. Example: https://www.toddlahman.com/
     * @param string $software_title   The name, or title, of the product. The title is not sent to the API Manager APIs, but is used for menu titles.
     *
     */

    global $ducVersion;
    global $duc_wc_api;
    $duc_wc_api = new WC_AM_Client_2_7( __FILE__, '486867', $ducVersion, 'plugin', 'https://besuperfly.com/', 'Divi Under Construction' );
}

function divi_under_construction_admin_enqueue() {
	wp_enqueue_script('divi-under-construction-admin', plugins_url( '/js/divi-under-construction-admin.min.js', __FILE__ ), array('jquery'));
	wp_enqueue_style('divi-under-construction-admin-style', plugins_url( '/css/divi-under-construction-admin.min.css', __FILE__ ), '1.0.0');		
	wp_enqueue_style( 'epanel-style', get_template_directory_uri() . '/epanel/css/panel.css', array(), et_get_theme_version() );
}
add_action( 'admin_enqueue_scripts', 'divi_under_construction_admin_enqueue' );

add_action( 'admin_menu', 'divi_under_construction_admin_menu', 105);
function divi_under_construction_admin_menu() {
	add_submenu_page( 'et_divi_options', 'Divi Under Construction', 'Under Construction', 'manage_options', 'divi_under_construction', 'divi_under_contruction_admin_page' ); 
}
function divi_under_contruction_admin_page() {
	?>
	<div id="wrapper">
		<div id="panel-wrap">
			<div id="epanel-wrapper">
				<div id="epanel">
					<div id="epanel-content-wrap">
						<div class="wrap" id="divi-under-construction-admin">
							<div id="epanel-header">
								<h1 id="epanel-title">Divi Under Construction</h1>
							</div>
							<div id="epanel-content">
								<div class="et-tab-content ui-widget-content ui-corner-bottom">
									<form action="options.php" method="post">
										<?php settings_fields('divi_under_construction_options'); ?>
										<?php do_settings_sections('divi_under_construction'); ?>			 
										<input name="Submit" type="submit" class="et-save-button" value="<?php esc_attr_e('Save Changes'); ?>" />
									</form>
								</div>
							</div> <!-- end epanel content -->
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<?php
}

add_action('template_redirect', 'divi_under_construction_check');
function divi_under_construction_check() {
	// Get options
	$options = get_option('divi_under_construction_options');

	// If Under Construction is enabled and a page is set
	if(isset($options['enabled']) && $options['enabled'] && isset($options['page'])) {

		$currentUrl = get_site_url() . $_SERVER['REQUEST_URI'];
		// Get current page ID
		if(url_to_postid($currentUrl)) {
			$currentId = url_to_postid($currentUrl);	
		}
		else {
			$currentId = null;
		}

		// Don't redirect logged in users
		if(!is_user_logged_in()) {

			if(isset($options['exclude'])){
				if(in_array($currentId, $options['exclude'])){
					$excluded = true;
				}else{
					$excluded = false;
				}
			}

			// Don't redirect whitelisted IP addresses
			if(isset($options['ip']) && $options['ip'] != '') {
				$allowed_ip_addresses = explode("\n", $options['ip']);
				$allowed_ip_addresses = array_map('trim', $allowed_ip_addresses);

				// Get client IP address
				if (!empty( $_SERVER['HTTP_CLIENT_IP'])) {
					$ip = $_SERVER['HTTP_CLIENT_IP'];
				} 
				elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
					$ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
				} 
				else {
					$ip = $_SERVER['REMOTE_ADDR'];
				}
				$ip = (string) $ip;

				if(in_array($ip, $allowed_ip_addresses)) {
					$whitelisted = true;	
				}
				else {
					$whitelisted = false;
				}

			}else{
				$whitelisted = false;
			}

			if($whitelisted == true){
				$redirect = false;
			}elseif($whitelisted == false && $excluded == false){
				$redirect = true;
			}elseif($whitelisted == false && $excluded == true){
				$redirect = false;
			}

		}else {
			$redirect = false;
		}

		// Do or do not redirect
		if($redirect) {

			// If not already on set page, redirect to that page
			if(!isset($currentId) || $currentId != $options['page']) {
				 
				wp_redirect(get_permalink($options['page']));
 			    exit;
			}
		}
	}
}

    add_action('wp', 'headers');

    function headers(){
       $options = get_option('divi_under_construction_options');

	// If Under Construction is enabled and a page is set
	if(isset($options['enabled']) && $options['enabled'] && isset($options['page'])) {
             if (is_page($options['page'])) {
                   status_header( 503 );
					nocache_headers();
             }
	}
           
    }

add_action('admin_init', 'divi_under_construction_admin_init');
function divi_under_construction_admin_init(){
	register_setting( 'divi_under_construction_options', 'divi_under_construction_options');
	add_settings_section('divi_under_construction_enabled', '', 'divi_under_construction_section_enabled_text', 'divi_under_construction');
    add_settings_section('divi_under_construction_main', '', 'divi_under_construction_section_main', 'divi_under_construction');
	add_settings_field('divi_under_construction_enabled', 'Enabled', 'divi_under_construction_setting_enabled', 'divi_under_construction', 'divi_under_construction_enabled');
	add_settings_field('divi_under_construction_page', 'Redirect To', 'divi_under_construction_setting_page', 'divi_under_construction', 'divi_under_construction_main');
	add_settings_field('divi_under_construction_exclude', 'Exclude Page(s)', 'divi_under_construction_exclude_pages', 'divi_under_construction', 'divi_under_construction_main');
	add_settings_field('divi_under_construction_ip', 'Bypass IP Addresses', 'divi_under_construction_setting_ip', 'divi_under_construction', 'divi_under_construction_main');
}

function divi_under_construction_section_enabled_text() {
	echo '<p>When enabled, users that are not logged in will be redirected to the page selected below if they try to visit any other page on your site.</p>';
}

function divi_under_construction_section_main() {
}

function divi_under_construction_setting_enabled() {
	$options = get_option('divi_under_construction_options');
	if(isset($options['enabled'])) {
		echo '<input type="checkbox" name="divi_under_construction_options[enabled]" checked>';	
	}
	else {
		echo '<input type="checkbox" name="divi_under_construction_options[enabled]">';
	}
}

function divi_under_construction_setting_page() {
	$options = get_option('divi_under_construction_options');
	echo '<select name="divi_under_construction_options[page]">';
	$pages = get_pages(array('post_type' => 'page'));
	foreach($pages as $page) {
		if($options['page'] == $page->ID) {
			echo '<option value="' . $page->ID . '" selected>' . esc_html($page->post_title) . '</option>';
		}
		else {
			echo '<option value="' . $page->ID . '">' . esc_html($page->post_title) . '</option>';
		}		
	}
	echo '</select>';
}

function divi_under_construction_exclude_pages() {
	echo "<p>Hold CTRL/CMD for multiple selections or to deselect chosen selections</p><br />";
	$options = get_option('divi_under_construction_options');
	echo '<select name="divi_under_construction_options[exclude][]" multiple>';
	$pages = get_pages(array('post_type' => 'page'));
	$selected = '';
	foreach($pages as $page) {
		if(isset($options['exclude'])) {
			$selected = in_array( $page->ID, $options['exclude'] ) ? ' selected="selected" ' : '';
		}
		echo '<option value="' . $page->ID . '"' . $selected . '>' . esc_html($page->post_title) . '</option>';
	}
	echo '</select>';
}

function divi_under_construction_setting_ip() {
	$options = get_option('divi_under_construction_options');
	echo '<p>Enter one IP address per line. Users visiting from these IP addresses will not be redirected. If no IP addresses are entered, any logged in user will not be redirected.</p><br>';
	echo '<textarea name="divi_under_construction_options[ip]" rows="10">';
	if(isset($options['ip'])) {
		echo esc_textarea($options['ip']);
	}
	echo '</textarea>';
}

?>