<?php

class DBP_Module extends ET_Builder_Module {

	public $slug       = 'dbp_divi_background_plus';
	public $vb_support = 'on';

	protected $module_credits = array(
		'module_uri' => 'https://besuperfly.com/product/divi-background-plus/',
		'author'     => 'BeSuperfly',
		'author_uri' => 'https://besuperfly.com/',
	);

	public function init() {
		$this->name = esc_html__( 'Divi Background Plus', 'dbp-divi-background-plus' );

        $this->settings_modal_toggles = array(
            'general'  => array(
                'toggles' => array(
                    'layout'     => esc_html__( 'Layout', 'dbp-divi-background-plus' ),
                    'neatjs'     => esc_html__( 'Animated Gradient', 'dbp-divi-background-plus' ),
                ),
            )
        );
	}

	public function dequeue_frontend_bundle() {
	    wp_dequeue_script( "{$this->name}-frontend-bundle" );
	}

	public function get_fields() {
		$fields = array(
            'level' => array(
                'label'             => esc_html__( 'Level', 'dbp-divi-background-plus' ),
                'type'              => 'select',
                'options'           => array(
                    'section' => esc_html__( 'Section', 'dbp-divi-background-plus' ),
                    'row' => esc_html__( 'Row', 'dbp-divi-background-plus' ),
                    'column' => esc_html__( 'Column', 'dbp-divi-background-plus' )
                ),
                'default'           => 'section',
                'description'       => esc_html__( 'Choose what level to place the overlay.', 'dbp-divi-background-plus' ),
                'toggle_slug'     => 'layout',
            ),
            'use_animated_gradient' => array(
                'label'             => esc_html__('Insert animated gradient', 'et_builder'),
                'type'              => 'yes_no_button',
                'description'     => esc_html__('Enable to show a down arrow icon next to menu items with child pages.', 'et_builder'),
                'options'           => array(
                    'on'  => esc_html__('Yes', 'et_builder'),
                    'off' => esc_html__('No', 'et_builder'),
                ),
                'default'           => 'off',
                'toggle_slug'       => 'neatjs',
            ),
            'animated_gradient_preset' => array(
                'label'             => esc_html__( 'Preset', 'dbp-divi-background-plus' ),
                'type'              => 'select',
                'options'           => array(
                    'stripe' => esc_html__( 'Stripe', 'dbp-divi-background-plus' ),
                    'flame' => esc_html__( 'Flame', 'dbp-divi-background-plus' ),
                    'nighttime' => esc_html__( 'Night Time', 'dbp-divi-background-plus' ),
                    'prussian' => esc_html__( 'Prussian', 'dbp-divi-background-plus' ),
                    'pastel' => esc_html__( 'Pastel', 'dbp-divi-background-plus' ),
                    'oceans' => esc_html__( 'Oceans', 'dbp-divi-background-plus' ),
                    'custom' => esc_html__( 'Custom', 'dbp-divi-background-plus' )
                ),
                'default'           => 'stripe',
                'description'       => esc_html__( 'Choose what level to place the overlay.', 'dbp-divi-background-plus' ),
                'toggle_slug'     => 'neatjs',
                'show_if'         => array(
					'use_animated_gradient' => 'on'				),
            ),
            'color_1' => array(
                'label'             => esc_html__( 'Color 1', 'dbp-divi-background-plus' ),
                'type'              => 'color-alpha',
                'default'           => '#FF5772',
                'custom_color'      => true,
                'options'           => array(
                    'section' => esc_html__( 'Section', 'dbp-divi-background-plus' ),
                    'row' => esc_html__( 'Row', 'dbp-divi-background-plus' ),
                    'column' => esc_html__( 'Column', 'dbp-divi-background-plus' )
                ),
                'description'       => esc_html__( 'Choose what level to place the overlay.', 'dbp-divi-background-plus' ),
                'toggle_slug'     => 'neatjs',
                'depends_show_if' => 'on',
				'show_if'         => array(
					'use_animated_gradient' => 'on',
                    'animated_gradient_preset' => 'custom'
				)
            ),
            'color_2' => array(
                'label'             => esc_html__( 'Color 2', 'dbp-divi-background-plus' ),
                'type'              => 'color-alpha',
                'default'           => '#4CB4BB',
                'custom_color'      => true,
                'options'           => array(
                    'section' => esc_html__( 'Section', 'dbp-divi-background-plus' ),
                    'row' => esc_html__( 'Row', 'dbp-divi-background-plus' ),
                    'column' => esc_html__( 'Column', 'dbp-divi-background-plus' )
                ),
                'description'       => esc_html__( 'Choose what level to place the overlay.', 'dbp-divi-background-plus' ),
                'toggle_slug'     => 'neatjs',
                'show_if'         => array(
					'use_animated_gradient' => 'on',
                    'animated_gradient_preset' => 'custom'
				),
            ),
            'color_3' => array(
                'label'             => esc_html__( 'Color 3', 'dbp-divi-background-plus' ),
                'type'              => 'color-alpha',
                'default'           => '#FFC600',
                'custom_color'      => true,
                'options'           => array(
                    'section' => esc_html__( 'Section', 'dbp-divi-background-plus' ),
                    'row' => esc_html__( 'Row', 'dbp-divi-background-plus' ),
                    'column' => esc_html__( 'Column', 'dbp-divi-background-plus' )
                ),
                'description'       => esc_html__( 'Choose what level to place the overlay.', 'dbp-divi-background-plus' ),
                'toggle_slug'     => 'neatjs',
                'show_if'         => array(
					'use_animated_gradient' => 'on',
                    'animated_gradient_preset' => 'custom'
				),
            ),
            'color_4' => array(
                'label'             => esc_html__( 'Color 4', 'dbp-divi-background-plus' ),
                'type'              => 'color-alpha',
                'default'           => '#8B6AE6',
                'custom_color'      => true,
                'options'           => array(
                    'section' => esc_html__( 'Section', 'dbp-divi-background-plus' ),
                    'row' => esc_html__( 'Row', 'dbp-divi-background-plus' ),
                    'column' => esc_html__( 'Column', 'dbp-divi-background-plus' )
                ),
                'description'       => esc_html__( 'Choose what level to place the overlay.', 'dbp-divi-background-plus' ),
                'toggle_slug'     => 'neatjs',
                'show_if'         => array(
					'use_animated_gradient' => 'on',
                    'animated_gradient_preset' => 'custom'
				),
            ),
            'color_5' => array(
                'label'             => esc_html__( 'Color 5', 'dbp-divi-background-plus' ),
                'type'              => 'color-alpha',
                'default'           => '#2E0EC7',
                'custom_color'      => true,
                'options'           => array(
                    'section' => esc_html__( 'Section', 'dbp-divi-background-plus' ),
                    'row' => esc_html__( 'Row', 'dbp-divi-background-plus' ),
                    'column' => esc_html__( 'Column', 'dbp-divi-background-plus' )
                ),
                'description'       => esc_html__( 'Choose what level to place the overlay.', 'dbp-divi-background-plus' ),
                'toggle_slug'     => 'neatjs',
                'show_if'         => array(
					'use_animated_gradient' => 'on',
                    'animated_gradient_preset' => 'custom'
				),
            ),
            'speed' => array(
                'label'             => esc_html__( 'Speed', 'dbp-divi-background-plus' ),
                'type'              => 'range',
                'range_settings'    => array(
                    'min'  => '0',
                    'max'  => '10',
                    'step' => '0.5',
                ),
                'default'           => '2',     
                'description'       => esc_html__( 'Choose what level to place the overlay.', 'dbp-divi-background-plus' ),
                'toggle_slug'       => 'neatjs',
                'show_if'         => array(
					'use_animated_gradient' => 'on',
                    'animated_gradient_preset' => 'custom'
				),
            ),
            'color_blending' => array(
                'label'             => esc_html__( 'Blending', 'dbp-divi-background-plus' ),
                'type'              => 'range',
                'range_settings'  => array(
                    'min'  => '0',
                    'max'  => '10',
                    'step' => '1',
                ),
                'default'           => '8', 
                'description'       => esc_html__( 'Choose what level to place the overlay.', 'dbp-divi-background-plus' ),
                'toggle_slug'     => 'neatjs',
                'show_if'         => array(
					'use_animated_gradient' => 'on',
                    'animated_gradient_preset' => 'custom'
				),
            ),
            'color_horizontal' => array(
                'label'             => esc_html__( 'Horizontal', 'dbp-divi-background-plus' ),
                'type'              => 'range',
                'range_settings'  => array(
                    'min'  => '0',
                    'max'  => '10',
                    'step' => '1',
                ),
                'default'           => '3',
                'description'       => esc_html__( 'Choose what level to place the overlay.', 'dbp-divi-background-plus' ),
                'toggle_slug'     => 'neatjs',
                'show_if'         => array(
					'use_animated_gradient' => 'on',
                    'animated_gradient_preset' => 'custom'
				),
            ),
            'color_vertical' => array(
                'label'             => esc_html__( 'Vertical', 'dbp-divi-background-plus' ),
                'type'              => 'range',
                'range_settings'  => array(
                    'min'  => '0',
                    'max'  => '10',
                    'step' => '1',
                ),
                'default'           => '4',
                'description'       => esc_html__( 'Choose what level to place the overlay.', 'dbp-divi-background-plus' ),
                'toggle_slug'     => 'neatjs',
                'show_if'         => array(
					'use_animated_gradient' => 'on',
                    'animated_gradient_preset' => 'custom'
				),
            ),
            'frequency_x' => array(
                'label'             => esc_html__( 'Frequency X', 'dbp-divi-background-plus' ),
                'type'              => 'range',
                'range_settings'  => array(
                    'min'  => '0',
                    'max'  => '10',
                    'step' => '1',
                ),
                'default'           => '2',
                'description'       => esc_html__( 'Choose what level to place the overlay.', 'dbp-divi-background-plus' ),
                'toggle_slug'     => 'neatjs',
                'show_if'         => array(
					'use_animated_gradient' => 'on',
                    'animated_gradient_preset' => 'custom'
				),
            ),
            'frequency_y' => array(
                'label'             => esc_html__( 'Frequency Y', 'dbp-divi-background-plus' ),
                'type'              => 'range',
                'range_settings'  => array(
                    'min'  => '0',
                    'max'  => '10',
                    'step' => '1',
                ),
                'default'           => '3',
                'description'       => esc_html__( 'Choose what level to place the overlay.', 'dbp-divi-background-plus' ),
                'toggle_slug'     => 'neatjs',
                'show_if'         => array(
					'use_animated_gradient' => 'on',
                    'animated_gradient_preset' => 'custom'
				),
            ),
            'amplitude' => array(
                'label'             => esc_html__( 'Amplitude', 'dbp-divi-background-plus' ),
                'type'              => 'range',
                'range_settings'  => array(
                    'min'  => '0',
                    'max'  => '10',
                    'step' => '1',
                ),
                'default'           => '5',
                'description'       => esc_html__( 'Choose what level to place the overlay.', 'dbp-divi-background-plus' ),
                'toggle_slug'     => 'neatjs',
                'show_if'         => array(
					'use_animated_gradient' => 'on',
                    'animated_gradient_preset' => 'custom'
				),
            ),
            'shadows' => array(
                'label'             => esc_html__( 'Shadows', 'dbp-divi-background-plus' ),
                'type'              => 'range',
                'range_settings'  => array(
                    'min'  => '0',
                    'max'  => '10',
                    'step' => '1',
                ),
                'default'           => '1',
                'description'       => esc_html__( 'Choose what level to place the overlay.', 'dbp-divi-background-plus' ),
                'toggle_slug'     => 'neatjs',
                'show_if'         => array(
					'use_animated_gradient' => 'on',
                    'animated_gradient_preset' => 'custom'
				),
            ),
            'highlights' => array(
                'label'             => esc_html__( 'Highlights', 'dbp-divi-background-plus' ),
                'type'              => 'range',
                'range_settings'  => array(
                    'min'  => '0',
                    'max'  => '10',
                    'step' => '1',
                ),
                'default'           => '5',
                'description'       => esc_html__( 'Choose what level to place the overlay.', 'dbp-divi-background-plus' ),
                'toggle_slug'     => 'neatjs',
                'show_if'         => array(
					'use_animated_gradient' => 'on',
                    'animated_gradient_preset' => 'custom'
				),
            ),
            'saturation' => array(
                'label'             => esc_html__( 'Saturation', 'dbp-divi-background-plus' ),
                'type'              => 'range',
                'range_settings'  => array(
                    'min'  => '0',
                    'max'  => '10',
                    'step' => '1',
                ),
                'default'           => '7',
                'description'       => esc_html__( 'Choose what level to place the overlay.', 'dbp-divi-background-plus' ),
                'toggle_slug'     => 'neatjs',
                'show_if'         => array(
					'use_animated_gradient' => 'on',
                    'animated_gradient_preset' => 'custom'
				),
            ),
            'brightness' => array(
                'label'             => esc_html__( 'Brightness', 'dbp-divi-background-plus' ),
                'type'              => 'range',
                'range_settings'  => array(
                    'min'  => '0',
                    'max'  => '10',
                    'step' => '1',
                ),
                'default'           => '1',
                'description'       => esc_html__( 'Choose what level to place the overlay.', 'dbp-divi-background-plus' ),
                'toggle_slug'     => 'neatjs',
                'show_if'         => array(
					'use_animated_gradient' => 'on',
                    'animated_gradient_preset' => 'custom'
				),
            ),
            'resolution' => array(
                'label'             => esc_html__( 'Resolution', 'dbp-divi-background-plus' ),
                'type'              => 'range',
                'range_settings'  => array(
                    'min'  => '0.25',
                    'max'  => '2',
                    'step' => '0.5',
                ),
                'default'           => '1',
                'description'       => esc_html__( 'Choose what level to place the overlay.', 'dbp-divi-background-plus' ),
                'toggle_slug'     => 'neatjs',
                'show_if'         => array(
					'use_animated_gradient' => 'on',
                    'animated_gradient_preset' => 'custom'
				),
            ),
            'intensity' => array(
                'label'             => esc_html__( 'Intensity', 'dbp-divi-background-plus' ),
                'type'              => 'range',
                'range_settings'  => array(
                    'min'  => '0',
                    'max'  => '1',
                    'step' => '0.025',
                ),
                'default'           => '0.3',
                'description'       => esc_html__( 'Choose what level to place the overlay.', 'dbp-divi-background-plus' ),
                'toggle_slug'     => 'neatjs',
                'show_if'         => array(
					'use_animated_gradient' => 'on',
                    'animated_gradient_preset' => 'custom'
				),
            ),
            'scale' => array(
                'label'             => esc_html__( 'Scale', 'dbp-divi-background-plus' ),
                'type'              => 'range',
                'range_settings'  => array(
                    'min'  => '1',
                    'max'  => '100',
                    'step' => '1',
                ),
                'default'           => '3',
                'description'       => esc_html__( 'Choose what level to place the overlay.', 'dbp-divi-background-plus' ),
                'toggle_slug'     => 'neatjs',
                'show_if'         => array(
					'use_animated_gradient' => 'on',
                    'animated_gradient_preset' => 'custom'
				),
            ),
            'sparsity' => array(
                'label'             => esc_html__( 'Sparsity', 'dbp-divi-background-plus' ),
                'type'              => 'range',
                'range_settings'  => array(
                    'min'  => '0',
                    'max'  => '1',
                    'step' => '0.02',
                ),
                'default'           => '0.02',
                'description'       => esc_html__( 'Choose what level to place the overlay.', 'dbp-divi-background-plus' ),
                'toggle_slug'     => 'neatjs',
                'show_if'         => array(
					'use_animated_gradient' => 'on',
                    'animated_gradient_preset' => 'custom'
				),
            ),
            'grain_speed' => array(
                'label'             => esc_html__( 'Grain Speed', 'dbp-divi-background-plus' ),
                'type'              => 'range',
                'range_settings'  => array(
                    'min'  => '0',
                    'max'  => '1',
                    'step' => '0.1',
                ),
                'default'           => '1',
                'description'       => esc_html__( 'Choose what level to place the overlay.', 'dbp-divi-background-plus' ),
                'toggle_slug'     => 'neatjs',
                'show_if'         => array(
					'use_animated_gradient' => 'on',
                    'animated_gradient_preset' => 'custom'
				),
            ),
            'gradient_background_color' => array(
                'label'             => esc_html__( 'Background Color', 'dbp-divi-background-plus' ),
                'type'              => 'color-alpha',
                'default'           => '#003FFF',
                'custom-color'      => true,
                'description'       => esc_html__( 'Choose what level to place the overlay.', 'dbp-divi-background-plus' ),
                'toggle_slug'     => 'neatjs',
                'show_if'         => array(
					'use_animated_gradient' => 'on',
                    'animated_gradient_preset' => 'custom'
				),
            ),
            'wireframe' => array(
                'label'             => esc_html__( 'Wireframe Mode', 'dbp-divi-background-plus' ),
                'type'              => 'yes_no_button',
                'description'     => esc_html__('Enable to show a down arrow icon next to menu items with child pages.', 'et_builder'),
                'options'           => array(
                    'on'  => esc_html__('Yes', 'et_builder'),
                    'off' => esc_html__('No', 'et_builder'),
                ),
                'default'           => 'on',
                'toggle_slug'     => 'neatjs',
                'show_if'         => array(
					'use_animated_gradient' => 'on',
                    'animated_gradient_preset' => 'custom'
				),
            ),
        );
        return $fields;
	}

	public function get_advanced_fields_config() {
		return array(
			'button'         => false,
			'filters'        => false,
			'text'		     => false,
			'fonts' 		 => false,
			'margin_padding' => false,
			'borders'        => false,
			'box_shadow'     => false
		);
	}

	public function render( $attrs, $content = null, $render_slug ) {

        $use_animated_gradient = $this->props['use_animated_gradient'];
        $animated_gradient_preset = $this->props['animated_gradient_preset'];

        $dataNeatString = '';

        if('on' === $use_animated_gradient){
            switch ($animated_gradient_preset) {
                case 'stripe':
                    $dataNeat = array(
                        'colors' => array(
                            array(
                                'color' => '#FD113F',
                                'enabled' => true,
                            ),
                            array(
                                'color' => '#90E0FF',
                                'enabled' => true,
                            ),
                            array(
                                'color' => '#FFC858',
                                'enabled' => true,
                            ),
                            array(
                                'color' => '#753BFF',
                                'enabled' => true,
                            ),
                            array(
                                'color' => '#f5e1e5',
                                'enabled' => false,
                            ),
                        ),
                        'speed' => 2,
                        'horizontalPressure' => 5,
                        'verticalPressure' => 6,
                        'waveFrequencyX' => 1,
                        'waveFrequencyY' => 2,
                        'waveAmplitude' => 10,
                        'shadows' => 0,
                        'highlights' => 7,
                        'colorBrightness' => 1.05,
                        'colorSaturation' => 0,
                        'wireframe' => false,
                        'colorBlending' => 9,
                        'backgroundColor' => '#003FFF',
                        'backgroundAlpha' => 1,
                        'grainScale' => 0,
                        'grainSparsity' => 0,
                        'grainIntensity' => 0,
                        'grainSpeed' => 0,
                        'resolution' => 1,
                    );
                    break;
                case 'flame':
                    $dataNeat = array(
                        'colors' => array(
                            array(
                                'color' => '#FF0069',
                                'enabled' => true,
                            ),
                            array(
                                'color' => '#00EAFF',
                                'enabled' => true,
                            ),
                            array(
                                'color' => '#FFB700',
                                'enabled' => true,
                            ),
                            array(
                                'color' => '#B26AE6',
                                'enabled' => true,
                            ),
                            array(
                                'color' => '#2E0EC7',
                                'enabled' => true,
                            ),
                        ),
                        'speed' => 4,
                        'horizontalPressure' => 3,
                        'verticalPressure' => 4,
                        'waveFrequencyX' => 10,
                        'waveFrequencyY' => 0,
                        'waveAmplitude' => 10,
                        'shadows' => 5,
                        'highlights' => 10,
                        'colorBrightness' => 1,
                        'colorSaturation' => 2,
                        'wireframe' => false,
                        'colorBlending' => 9,
                        'backgroundColor' => '#003FFF',
                        'backgroundAlpha' => 1,
                        'grainScale' => 2,
                        'grainSparsity' => 0,
                        'grainIntensity' => 0.05,
                        'grainSpeed' => 1,
                        'resolution' => 0.5,
                    );
                    break;
                case 'nighttime':
                    $dataNeat = array(
                        'colors' => array(
                            array(
                                'color' => '#FF3087',
                                'enabled' => true,
                            ),
                            array(
                                'color' => '#1B36A6',
                                'enabled' => true,
                            ),
                            array(
                                'color' => '#002027',
                                'enabled' => true,
                            ),
                            array(
                                'color' => '#6D3BFF',
                                'enabled' => true,
                            ),
                            array(
                                'color' => '#f5e1e5',
                                'enabled' => false,
                            ),
                        ),
                        'speed' => 4,
                        'horizontalPressure' => 3,
                        'verticalPressure' => 5,
                        'waveFrequencyX' => 2,
                        'waveFrequencyY' => 3,
                        'waveAmplitude' => 5,
                        'shadows' => 0,
                        'highlights' => 2,
                        'colorBrightness' => 1,
                        'colorSaturation' => 7,
                        'wireframe' => false,
                        'colorBlending' => 7,
                        'backgroundColor' => '#003FFF',
                        'backgroundAlpha' => 1,
                        'grainScale' => 2,
                        'grainSparsity' => 0,
                        'grainIntensity' => 0.5,
                        'grainSpeed' => 1,
                        'resolution' => 1,
                    );
                    break;
                case 'prussian':
                    $dataNeat = array(
                        'colors' => array(
                            array(
                                'color' => '#0b3954',
                                'enabled' => true,
                            ),
                            array(
                                'color' => '#087e8b',
                                'enabled' => true,
                            ),
                            array(
                                'color' => '#bfd7ea',
                                'enabled' => true,
                            ),
                            array(
                                'color' => '#ff5a5f',
                                'enabled' => true,
                            ),
                            array(
                                'color' => '#c81d25',
                                'enabled' => true,
                            ),
                        ),
                        'speed' => 4,
                        'horizontalPressure' => 4,
                        'verticalPressure' => 3,
                        'waveFrequencyX' => 0,
                        'waveFrequencyY' => 0,
                        'waveAmplitude' => 0,
                        'shadows' => 2,
                        'highlights' => 7,
                        'colorBrightness' => 1,
                        'colorSaturation' => 8,
                        'wireframe' => false,
                        'colorBlending' => 5,
                        'backgroundColor' => '#FF0000',
                        'backgroundAlpha' => 1,
                        'grainScale' => 0,
                        'grainSparsity' => 0,
                        'grainIntensity' => 0,
                        'grainSpeed' => 0,
                        'resolution' => 0.5,
                    );
                    break;
                case 'pastel':
                    $dataNeat = array(
                        'colors' => array(
                            array(
                                'color' => '#cdb4db',
                                'enabled' => true,
                            ),
                            array(
                                'color' => '#ffc8dd',
                                'enabled' => true,
                            ),
                            array(
                                'color' => '#ffafcc',
                                'enabled' => true,
                            ),
                            array(
                                'color' => '#bde0fe',
                                'enabled' => true,
                            ),
                            array(
                                'color' => '#a2d2ff',
                                'enabled' => false,
                            ),
                        ),
                        'speed' => 4,
                        'horizontalPressure' => 4,
                        'verticalPressure' => 6,
                        'waveFrequencyX' => 2,
                        'waveFrequencyY' => 4,
                        'waveAmplitude' => 6,
                        'shadows' => 0,
                        'highlights' => 4,
                        'colorBrightness' => 1,
                        'colorSaturation' => 3,
                        'wireframe' => false,
                        'colorBlending' => 5,
                        'backgroundColor' => '#003FFF',
                        'backgroundAlpha' => 1,
                        'grainScale' => 0,
                        'grainSparsity' => 0,
                        'grainIntensity' => 0,
                        'grainSpeed' => 0,
                        'resolution' => 1,
                    );
                    break;
                case 'oceans':
                    $dataNeat = array(
                        'colors' => array(
                            array(
                                'color' => '#5365FF',
                                'enabled' => true,
                            ),
                            array(
                                'color' => '#5864FF',
                                'enabled' => true,
                            ),
                            array(
                                'color' => '#322085',
                                'enabled' => true,
                            ),
                            array(
                                'color' => '#3B94FF',
                                'enabled' => true,
                            ),
                            array(
                                'color' => '#E1F0F5',
                                'enabled' => false,
                            ),
                        ),
                        'speed' => 4,
                        'horizontalPressure' => 2,
                        'verticalPressure' => 10,
                        'waveFrequencyX' => 2,
                        'waveFrequencyY' => 10,
                        'waveAmplitude' => 10,
                        'shadows' => 10,
                        'highlights' => 0,
                        'colorBrightness' => 1.2,
                        'colorSaturation' => -3,
                        'wireframe' => false,
                        'colorBlending' => 10,
                        'backgroundColor' => '#003FFF',
                        'backgroundAlpha' => 0,
                        'grainScale' => 0,
                        'grainSparsity' => 0,
                        'grainIntensity' => 0,
                        'grainSpeed' => 10,
                        'resolution' => 1,
                    );
                    break;
                default:
                    $dataNeat = array(
                    'colors' => array(
                            array(
                            'color' => $this->props['color_1'],
                            'enabled' => substr($this->props['color_1'], 7) !== '00'
                            ),
                            array(
                            'color' => $this->props['color_2'],
                            'enabled' => substr($this->props['color_2'], 7) !== '00'
                            ),
                            array(
                            'color' => $this->props['color_3'],
                            'enabled' => substr($this->props['color_3'], 7) !== '00'
                            ),
                            array(
                            'color' => $this->props['color_4'],
                            'enabled' => substr($this->props['color_4'], 7) !== '00'
                            ),
                            array(
                            'color' => $this->props['color_5'],
                            'enabled' => substr($this->props['color_5'], 7) !== '00'
                            )
                        ),
                        'speed' => $this->props['speed'],
                        'horizontalPressure' => $this->props['color_horizontal'],
                        'verticalPressure' => $this->props['color_vertical'],
                        'waveFrequencyX' => $this->props['frequency_x'],
                        'waveFrequencyY' => $this->props['frequency_y'],
                        'waveAmplitude' => $this->props['amplitude'],
                        'shadows' => $this->props['shadows'],
                        'highlights' => $this->props['highlights'],
                        'colorBrightness' => $this->props['brightness'],
                        'colorSaturation' => $this->props['saturation'],
                        'wireframe' => isset($this->props['wireframe']) && '' !== $this->props['wireframe'] && 'on' !== $this->props['wireframe'] ? true : false,
                        'colorBlending' => $this->props['color_blending'],
                        'backgroundColor' => $this->props['gradient_background_color'],
                        'backgroundAlpha' => 1,
                        'grainScale' => $this->props['scale'],
                        'grainIntensity' => $this->props['intensity'],
                        'grainSpeed' => $this->props['grain_speed'],
                        'resolution' => $this->props['resolution']
                    );
                    break;
                }

                $dataNeatString = json_encode($dataNeat);
              
        }

        $gradientOutput = '';

        if('on' === $use_animated_gradient){
            $gradientOutput = sprintf('<canvas data-neat=%1$s id="my-canvas"></canvas>',
                $dataNeatString
            );
        }

        return sprintf(
            '<div class="dbp_divi_background_plus_inner" data-level="%1$s">DB+</div>%2$s',
            $this->props['level'],
            $gradientOutput
        );
	}
}

new DBP_Module;
