<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* AndroidDeviceOwnerKioskModeIconSize File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Solid_Backups\Strauss\Beta\Microsoft\Graph\Model;

use Solid_Backups\Strauss\Microsoft\Graph\Core\Enum;

/**
* AndroidDeviceOwnerKioskModeIconSize class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class AndroidDeviceOwnerKioskModeIconSize extends Enum
{
    /**
    * The Enum AndroidDeviceOwnerKioskModeIconSize
    */
    const NOT_CONFIGURED = "notConfigured";
    const SMALLEST = "smallest";
    const SMALL = "small";
    const REGULAR = "regular";
    const LARGE = "large";
    const LARGEST = "largest";
}