<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* TenantSources File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Solid_Backups\Strauss\Beta\Microsoft\Graph\Ediscovery\Model;

use Solid_Backups\Strauss\Microsoft\Graph\Core\Enum;

/**
* TenantSources class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class TenantSources extends Enum
{
    /**
    * The Enum TenantSources
    */
    const ALL_MAILBOXES = "allMailboxes";
    const ALL_SITES = "allSites";
    const UNKNOWN_FUTURE_VALUE = "unknownFutureValue";
}